dofile(LockOn_Options.script_path.."Multipurpose_Display_Group/Common/indicator/Pages/MPD/MPD_page_defs.lua")
dofile(LockOn_Options.script_path.."Multipurpose_Display_Group/Common/indicator/Pages/MPD/HSI/HSI_Definitions.lua")

local ewRootName = "SA_EW_Root"
addPlaceholder(ewRootName, {0, 0}, nil, {{"MPD_SA_EW_Show"}})

local EW_LittleCompasRadius = 360
local EW_BigCompasRadius = 720
local EW_Symbol_Scale = 1.65

local function AddEwSymbol(num, level)
	local EW_Symbol_Root = "EW_Symbol_Root"..num
	local clippedObject
	addPlaceholder(EW_Symbol_Root, {0, 0}, ewRootName, {{"MPD_SA_EW_Symbol_Pos", num, EW_LittleCompasRadius, EW_BigCompasRadius, offsetDecenterPivot}})
	clippedObject = addStrokeSymbol("SA_EW_Symbol_Main"..num, {"stroke_symbols_MDI_AMPCD", "SA-EW-Symbol"}, "FromSet", nil, EW_Symbol_Root, {{"MPD_SA_EW_Symbol_Rotate", num}}, EW_Symbol_Scale)
	setClipLevel(clippedObject, level)
	clippedObject = addStrokeText("SA_EW_ThreatSymbol"..num, "", STROKE_FNT_DFLT_100, "CenterCenter", nil, EW_Symbol_Root, {{"MPD_SA_EW_ThreatSymbol", num}})
	setClipLevel(clippedObject, level)
	clippedObject = addStrokeSymbol("SA_EW_Symbol_SecondLine"..num, {"stroke_symbols_MDI_AMPCD", "SA-EW-Symbol-Second-Line"}, "FromSet", nil, "SA_EW_Symbol_Main"..num, {{"MPD_SA_EW_PriorityLine", num, 2}}, EW_Symbol_Scale)
	setClipLevel(clippedObject, level)
	clippedObject = addStrokeSymbol("SA_EW_Symbol_ThirdLine"..num, {"stroke_symbols_MDI_AMPCD", "SA-EW-Symbol-Third-Line"}, "FromSet", nil, "SA_EW_Symbol_Main"..num, {{"MPD_SA_EW_PriorityLine", num, 1}}, EW_Symbol_Scale)
	setClipLevel(clippedObject, level)
end

local EW_Indices = {0, 1, 2}
local EW_SymWidth = 48 * EW_Symbol_Scale
local EW_SymHeight = 42 * EW_Symbol_Scale
local EW_Vertices = 
{
	{-EW_SymWidth / 2, EW_SymHeight / 2},
	{ EW_SymWidth / 2, EW_SymHeight / 2},
	{ 0, -EW_SymHeight / 2}	
}

local openingMaskEW = openMaskArea(0, "EW_Mask", EW_Vertices, EW_Indices, {0, -5 * EW_Symbol_Scale }, ewRootName, {{"MPD_SA_EW_Symbol_Pos", 0, EW_LittleCompasRadius, EW_BigCompasRadius, offsetDecenterPivot}})
for i = 1,4 do
	local num = i-1
	local level = 0
	if i == 1 then
		level = 1
	end

	AddEwSymbol(num, level)
end
closeMaskArea(1, "EW_Mask_Close", openingMaskEW.vertices, openingMaskEW.indices, openingMaskEW.init_pos)